/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.lib.sentry;

import dev.tr7zw.lib.sentry.CustomSamplingContext;
import dev.tr7zw.lib.sentry.TransactionContext;
import dev.tr7zw.lib.sentry.util.Objects;
import dev.tr7zw.lib.sentry.util.SentryRandom;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SamplingContext {
    @NotNull
    private final TransactionContext transactionContext;
    @Nullable
    private final CustomSamplingContext customSamplingContext;
    @NotNull
    private final Double sampleRand;
    @NotNull
    private final Map<String, Object> attributes;

    @Deprecated
    public SamplingContext(@NotNull TransactionContext transactionContext, @Nullable CustomSamplingContext customSamplingContext) {
        this(transactionContext, customSamplingContext, SentryRandom.current().nextDouble(), null);
    }

    @ApiStatus.Internal
    public SamplingContext(@NotNull TransactionContext transactionContext, @Nullable CustomSamplingContext customSamplingContext, @NotNull Double sampleRand, @Nullable Map<String, Object> attributes) {
        this.transactionContext = Objects.requireNonNull(transactionContext, "transactionContexts is required");
        this.customSamplingContext = customSamplingContext;
        this.sampleRand = sampleRand;
        this.attributes = attributes == null ? Collections.emptyMap() : attributes;
    }

    @Nullable
    public CustomSamplingContext getCustomSamplingContext() {
        return this.customSamplingContext;
    }

    @NotNull
    public TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    @NotNull
    public Double getSampleRand() {
        return this.sampleRand;
    }

    @Nullable
    public Object getAttribute(@Nullable String key) {
        if (key == null) {
            return null;
        }
        return this.attributes.get(key);
    }
}

